<VirtualHost 185.251.91.96:80>
	ServerName files.russiaglorysongs.ru
	ServerAlias www.files.russiaglorysongs.ru
	DocumentRoot /var/www/www-root/data/www/files.russiaglorysongs.ru
	ServerAdmin webmaster@files.russiaglorysongs.ru
	DirectoryIndex index.php index.html
	AddDefaultCharset off
	AssignUserID www-root www-root
	CustomLog /var/www/httpd-logs/files.russiaglorysongs.ru.access.log combined
	ErrorLog /var/www/httpd-logs/files.russiaglorysongs.ru.error.log
	<FilesMatch "\.ph(p[3-5]?|tml)$">
		SetHandler application/x-httpd-php
	</FilesMatch>
	<FilesMatch "\.phps$">
		SetHandler application/x-httpd-php-source
	</FilesMatch>
	<IfModule php5_module>
		php_admin_value sendmail_path "/usr/sbin/sendmail -t -i -f webmaster@files.russiaglorysongs.ru"
		php_admin_value upload_tmp_dir "/var/www/www-root/data/mod-tmp"
		php_admin_value session.save_path "/var/www/www-root/data/mod-tmp"
		php_admin_value open_basedir "/var/www/www-root/data:."
	</IfModule>
	<IfModule php7_module>
		php_admin_value sendmail_path "/usr/sbin/sendmail -t -i -f webmaster@files.russiaglorysongs.ru"
		php_admin_value upload_tmp_dir "/var/www/www-root/data/mod-tmp"
		php_admin_value session.save_path "/var/www/www-root/data/mod-tmp"
		php_admin_value open_basedir "/var/www/www-root/data:."
	</IfModule>
	<IfModule php_module>
		php_admin_value sendmail_path "/usr/sbin/sendmail -t -i -f webmaster@files.russiaglorysongs.ru"
		php_admin_value upload_tmp_dir "/var/www/www-root/data/mod-tmp"
		php_admin_value session.save_path "/var/www/www-root/data/mod-tmp"
		php_admin_value open_basedir "/var/www/www-root/data:."
	</IfModule>
</VirtualHost>
<VirtualHost 185.251.91.96:443>
	ServerName files.russiaglorysongs.ru
	ServerAlias www.files.russiaglorysongs.ru
	DocumentRoot /var/www/www-root/data/www/files.russiaglorysongs.ru
	ServerAdmin webmaster@files.russiaglorysongs.ru
	DirectoryIndex index.php index.html
	AddDefaultCharset off
	SSLEngine on
	SSLCertificateFile "/var/www/httpd-cert/www-root/files.russiaglorysongs.ru_le1.crt"
	SSLCertificateKeyFile "/var/www/httpd-cert/www-root/files.russiaglorysongs.ru_le1.key"
	SSLHonorCipherOrder on
	SSLProtocol +TLSv1 +TLSv1.1 +TLSv1.2 +TLSv1.3
	SSLCipherSuite EECDH:+AES256:-3DES:RSA+AES:!NULL:!RC4
	AssignUserID www-root www-root
	CustomLog /var/www/httpd-logs/files.russiaglorysongs.ru.access.log combined
	ErrorLog /var/www/httpd-logs/files.russiaglorysongs.ru.error.log
	<FilesMatch "\.ph(p[3-5]?|tml)$">
		SetHandler application/x-httpd-php
	</FilesMatch>
	<FilesMatch "\.phps$">
		SetHandler application/x-httpd-php-source
	</FilesMatch>
	<IfModule php5_module>
		php_admin_value sendmail_path "/usr/sbin/sendmail -t -i -f webmaster@files.russiaglorysongs.ru"
		php_admin_value upload_tmp_dir "/var/www/www-root/data/mod-tmp"
		php_admin_value session.save_path "/var/www/www-root/data/mod-tmp"
		php_admin_value open_basedir "/var/www/www-root/data:."
	</IfModule>
	<IfModule php7_module>
		php_admin_value sendmail_path "/usr/sbin/sendmail -t -i -f webmaster@files.russiaglorysongs.ru"
		php_admin_value upload_tmp_dir "/var/www/www-root/data/mod-tmp"
		php_admin_value session.save_path "/var/www/www-root/data/mod-tmp"
		php_admin_value open_basedir "/var/www/www-root/data:."
	</IfModule>
	<IfModule php_module>
		php_admin_value sendmail_path "/usr/sbin/sendmail -t -i -f webmaster@files.russiaglorysongs.ru"
		php_admin_value upload_tmp_dir "/var/www/www-root/data/mod-tmp"
		php_admin_value session.save_path "/var/www/www-root/data/mod-tmp"
		php_admin_value open_basedir "/var/www/www-root/data:."
	</IfModule>
	SSLCertificateChainFile "/var/www/httpd-cert/www-root/files.russiaglorysongs.ru_le1.ca"
</VirtualHost>
<Directory /var/www/www-root/data/www/files.russiaglorysongs.ru>
	Options +Includes -ExecCGI
	<IfModule php5_module>
		php_admin_flag engine on
	</IfModule>
	<IfModule php7_module>
		php_admin_flag engine on
	</IfModule>
	<IfModule php_module>
		php_admin_flag engine on
	</IfModule>
</Directory>
<Directory /var/www/www-root/data/www/files.russiaglorysongs.ru/pub/locked>
	Allow from all
	AuthName "Access limited by ISPmanager"
	AuthType Basic
	AuthUserFile /var/www/www-root/data/etc/access.files.russiaglorysongs.ru.+QSrK+s2.passwd
	Order allow,deny
	Require valid-user
</Directory>
